/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftblibrary.config.ui;

import com.google.common.base.Suppliers;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.icon.ItemIcon;
import dev.ftb.mods.ftblibrary.util.SetOfItemStack;
import dev.ftb.mods.ftblibrary.util.client.ClientUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;

public interface ItemSearchMode {
    public static final ItemSearchMode ALL_ITEMS = new ItemSearchMode(){
        private final Supplier<Collection<ItemStack>> supplier = Suppliers.memoize(this::computeStacks);

        @Override
        public Icon getIcon() {
            return ItemIcon.getItemIcon(Items.COMPASS);
        }

        @Override
        public MutableComponent getDisplayName() {
            return Component.translatable((String)"ftblibrary.select_item.list_mode.all");
        }

        @Override
        public Collection<ItemStack> getAllItems() {
            return this.supplier.get();
        }

        private Set<ItemStack> computeStacks() {
            CreativeModeTabs.tryRebuildTabContents((FeatureFlagSet)FeatureFlags.DEFAULT_FLAGS, (boolean)false, (HolderLookup.Provider)ClientUtils.registryAccess());
            return new SetOfItemStack(CreativeModeTabs.allTabs().stream().flatMap(tab -> tab.getDisplayItems().stream()).toList());
        }
    };
    public static final ItemSearchMode INVENTORY = new ItemSearchMode(){

        @Override
        public Icon getIcon() {
            return ItemIcon.getItemIcon(Items.CHEST);
        }

        @Override
        public MutableComponent getDisplayName() {
            return Component.translatable((String)"ftblibrary.select_item.list_mode.inv");
        }

        @Override
        public Collection<ItemStack> getAllItems() {
            LocalPlayer player = Minecraft.getInstance().player;
            if (player == null) {
                return Collections.emptySet();
            }
            int invSize = player.getInventory().getContainerSize();
            ArrayList<ItemStack> items = new ArrayList<ItemStack>(invSize);
            for (int i = 0; i < invSize; ++i) {
                ItemStack stack = player.getInventory().getItem(i);
                if (stack.isEmpty()) continue;
                items.add(stack);
            }
            return items;
        }
    };

    public Icon getIcon();

    public MutableComponent getDisplayName();

    public Collection<ItemStack> getAllItems();
}

